(
	-- UV Generator 

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"d472fb22-9c8d-44f4-bcaa-cef1dd62cc61"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			-- If we have an UVW override, we just use that...
			if (AMG_UVW_override != undefined) then
			(
				join res AMG_uvw_override
			)
			else
			(
				-- Environment mode cannot use varying attributes
				if (mtl.mappingType == 0 and context != 2) do
				(
					append res #("uvw",      undefined, "uvw_"       + (mtl.mapChannel as String))
					append res #("utangent", undefined, "u_tangent_" + (mtl.mapChannel as String))
					append res #("vtangent", undefined, "v_tangent_" + (mtl.mapChannel as String))
				)
			)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("mapSlotType",   mtl.mappingType)
			append res #("mapType",       mtl.mapping)     
			append res #("showMapOnBack", mtl.showMapOnBack)

			append res #("utile", mtl.U_Tile)
			append res #("vtile", mtl.V_Tile)
			append res #("umirror", mtl.U_Mirror)
			append res #("vmirror", mtl.V_Mirror)

			-- Thankfully, all the transform-craziness gets baked into this one parameter.... <3 you max
			append res #("UVTransform", mtl.UVTransform)
			append res #("TangentTransform", orthogonalize(inverse(mtl.UVTransform)))

			append res #("blur",      mtl.blur) 
			append res #("blurOffs",  mtl.Blur_Offset) 

			append res #("ns",     mtl.Noise_On) 
			append res #("nsAni",  mtl.Noise_Animate) 
			append res #("nsAmt",  mtl.Noise_Amount) 
			append res #("nsPhs",  mtl.phase) 
			append res #("nsSize", mtl.Noise_Size) 
			append res #("nsLev",  mtl.Noise_Levels) 
	
 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCYiN4SJB8zXRtG2Oeu3IA2S+f6Zxey5CZT
-- yFctoeBU6PLyA9/EdPGQI9VWXLi7T7F9rUgGwqS/xyKV9Hcx8kOYzl/eaP6QxcS1
-- tfYvwF4aLlwWqBHf2DM1Sa8Cq+hNn0Qh8qVYApU1fuoAQW8MMFURJw/gG0vs1UzE
-- vJFKPwb5kdoJDT9bGLbKj6BRxggvgZK3C3+9wOEXG+MSC6aF/uV7+ehg3E4P9FoP
-- GveW5iKONxX6qumSre4v5QW0sZtQ6MJibBtKqswj8Od9qz64dyfOX4G6FA0Przsl
-- nDm9ffndyWjknRPjrDvILU4ALeFq0ULIEVh25OLKI6KQ/jfgZ/fd
-- -----END-SIGNATURE-----